public class Crypto {
   /** Given y != 0, yield x mod y: the value r such that
       x = q*y + r  and  0 <= r < abs(y) (for some q) */
   public static long mod(long x, long y) {
      // q*y + r  =  (-q)*(-y) + r ,
      // so r depends only on abs(y)
      y= Math.abs(y);

      // For x >= 0 and y > 0, mod(x,y) = x % y
      // For x <  0 and y > 0, x % y is the value r that
      // satisfies x = q*y + r and y < r <= 0.
      long r= x % y;
      if (r >= 0) return r;
      return y+r;
   }
    
   /** Given a>=0, b>0, yield a**b */
   public static long exp(long a, long b) {
      long z= 1;
      long x= a;
      long y= b;
      // invariant a**b = z*x**y  and y >= 0
      while (y > 0) {
         if (y % 2 == 0)
             {x= x*x; y= y/2;}
         else {z= z*x; y= y-1;}
      }
      return z;
   }
    
   /** Given 0<=a<m, 0<b<m, yield a**b using modulo m arithmetic */
   public static long expMod(long a, long b, long m) {
      return 0;
   }
    
   /** Yield an array of size s.length(): element i of
       the array should be the encryption of character
       s.charAt[i], using a public key that consists of key k
       and modulus m. */
   public static long[] encrypt(String s, long k, long m) {
      long c[]= new long[s.length()];
      return c;
   }
        
   /** Yield a String of size c.length(): element i of the
       String should be the decryption of the integer c[i],
       using a private key that consists of key k and modulus m. */
   public static String decrypt(long[] c, long k, long m) {
      String s= "";
      int i= 0;
      // invariant: s[0..i-1] contains the decrypted versions
      //            of c[0..i-1]
      while (i != c.length) {
         s= s + (char)expMod(c[i], k, m); 
         i= i+1;
      }
      return s;
   }
    
   /** Yield an array c (say) of size s.length() that is
       the "fancy" encryption of String s. The definition of
       c is as follows, with all arithmetic being modulo m. First,<br><br>
          c[0] = expMod(s[0],k,m).<br><br>
      Then, for i in 1..s.length()-1,<br><br>
          c[i] = expMod(s[s_i] + c[i-1],k,m) */
   public static long[] fancyEncrypt(String s, long k, long m) {
      long c[]= new long[s.length()];
      return c;
   }
        
   /** Yield the fancy-decryption of array c, i.e. the String s
       such that fancyEncrypt(s,k,m) produced c.  */
   public static String fancyDecrypt(long[] c, long k, long m) {
      return "";
   }
 
}
